/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.verification.common;

import oracle.ops.mgmt.nls.MessageBundle;

public class CVUException
extends Exception {
    private static final String LSEP = System.getProperty("line.separator");
    private boolean m_isNoMsg = false;

    public CVUException(Throwable cause) {
        super(cause);
        this.m_isNoMsg = true;
    }

    public CVUException(String msg) {
        super(msg);
    }

    public CVUException(MessageBundle msgBundle, String key, Object ... args) {
        this((Throwable)null, msgBundle, key, args);
    }

    public CVUException(Throwable cause, MessageBundle msgBundle, String key, Object ... args) {
        super(msgBundle.getMessage(key, true, args), cause);
    }

    public CVUException(String cause, MessageBundle msgBundle, String key, Object ... args) {
        super(cause + LSEP + msgBundle.getMessage(key, true, args));
    }

    @Override
    public String toString() {
        return this.getMessage();
    }

    @Override
    public String getMessage() {
        Throwable causedBy = super.getCause();
        if (causedBy == null) {
            return super.getMessage();
        }
        String supermsg = super.getMessage();
        String causedmsg = causedBy.getMessage();
        if (this.m_isNoMsg) {
            return causedmsg;
        }
        return supermsg + LSEP + causedmsg;
    }
}

